import FullNews from '@inside-news/components/lib/Full'
import MinimalNews from '@inside-news/components/lib/Minimal'

export default {
  'inside-ged': {
    useV2: true,
    allowReportPictures: false
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: false,
      useBackgroundImage: true
    },
    csvImport: true,
    extraFields: [{ markets: ['machine_name'] }],
    fieldsBlacklist: ['name'],
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] }
      ]
    }
  },
  'inside-news': {
    showBookmarks: false,
    likesEnabled: false
  },
  'inside-layouts': {
    templates: {
      fullContent: {
        favorites: {
          mainComponent: FullNews,
          relatedComponent: MinimalNews
        },
        trends: {
          mainComponent: FullNews,
          relatedComponent: MinimalNews
        }
      }
    }
  },
  'inside-statistics': {
    contentsWithStats: [
      'bu_highlights',
      'documents',
      'trends',
      'favorites',
      'catalogs_cos',
      'catalogs_nutra',
      'catalogs_pharma'
    ]
  }
}
