import { http } from '@inside-library/helpers/Http'
import { categoriesFieldsWithSubCategories } from '../../constants/news-fields'

const fetchTrendsCategories = async () => {
  try {
    const { data } = await http.get('content/trends_categories', {
      fields: categoriesFieldsWithSubCategories,
      filters: { 'status:eq': 1 }
    })

    return data.reduce(
      (acc, item) => {
        if (item.trends_categories) {
          const key = item.trends_categories.uuid

          if (!(key in acc.children)) {
            acc.children[key] = []
          }

          acc.children[key].push(item)
        } else {
          acc.parents.push(item)
        }

        return acc
      },
      { parents: [], children: {} }
    )
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchTrendsCategories }
