import BuPage from '../pages/BusinessUnitPage'
import { fetchBuSpace } from '../components/business-units/fetch'

import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

const buRoot = {
  fr: '/espace',
  en: '/space'
}

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    path: {
      fr: '/tendances',
      en: '/trends'
    },
    name: 'Trends',
    component: () => import('../pages/TrendsListingPage')
  },
  {
    path: {
      fr: '/tendances/:slug',
      en: '/trends/:slug'
    },
    name: 'TrendsPage',
    component: () => import('../pages/TrendsPage')
  },
  {
    path: {
      fr: '/coups-de-coeur',
      en: '/favorites'
    },
    name: 'Favorites',
    component: () => import('../pages/FavoritesListingPage')
  },
  {
    path: {
      fr: '/coups-de-coeur/:slug',
      en: '/favorites/:slug'
    },
    name: 'FavoritesPage',
    component: () => import('../pages/FavoritesPage')
  },
  // BUSINESS UNITS
  {
    name: 'BuPage',
    path: {
      fr: `${buRoot.fr}/:slug`,
      en: `${buRoot.en}/:slug`
    },
    component: withFetch(BuPage, { size: 'xxl', watch: true })(fetchBuSpace),
    meta: { content: 'business_units' }
  },
  {
    name: 'BuSimplePage',
    path: {
      fr: `${buRoot.fr}/:slug/page`,
      en: `${buRoot.en}/:slug/page`
    },
    meta: { content: 'business_units' }
  },
  {
    name: 'BuIframes',
    path: {
      fr: `${buRoot.fr}/:slug/iframe`,
      en: `${buRoot.en}/:slug/iframe`
    },
    component: () => import('../pages/BusinessUnitIframePage'),
    meta: { content: 'business_units' }
  },
  {
    name: 'BuGed',
    path: {
      fr: `${buRoot.fr}/:slug/bibliotheque`,
      en: `${buRoot.en}/:slug/library`
    },
    component: () => import('../pages/BusinessUnitGedPage'),
    meta: { content: 'business_units' }
  },
  {
    name: 'BuCatalog',
    path: {
      fr: `${buRoot.fr}/:slug/catalogue`,
      en: `${buRoot.en}/:slug/catalog`
    },
    component: () => import('../pages/BusinessUnitCatalogPage'),
    meta: { content: 'business_units' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { permissionKey: 'advanced-settings', display: true }
  }
]
