import { http } from '@inside-library/helpers/Http'

const getBuFromCatalog = async ({ contentType }) => {
  try {
    const { data } = await http.get('content/page_catalogs', {
      fields: [
        'uuid',
        {
          bu_highlights: {
            fields: [{ business_units: ['slug'] }],
            filters: { reverse: true }
          }
        }
      ],
      filters: { 'custom_slug:eq': contentType }
    })

    return {
      name: 'BuCatalog',
      params: { slug: data[0].bu_highlights.data[0].business_units.slug[0] }
    }
  } catch (err) {
    throw new Error(err)
  }
}

function searchCatalog(data, vm, modal) {
  setTimeout(() => {
    vm.triggerModal(
      `catalog-${modal}`,
      'fetch',
      {
        item: data,
        contentType: data.content_type
      },
      {
        layout: 'right',
        transition: 'fadeInLeft',
        size: 'm',
        useUrlParams: true
      }
    )
  }, 500)
}

export default {
  catalogsCos: {
    add: getBuFromCatalog,
    delete: getBuFromCatalog,
    globalSearch: ({ data, vm }) => ({
      routeAs: 'add',
      action: searchCatalog(data, vm, 'cos')
    })
  },
  catalogsNutra: {
    add: getBuFromCatalog,
    delete: getBuFromCatalog,
    globalSearch: ({ data, vm }) => ({
      routeAs: 'add',
      action: searchCatalog(data, vm, 'nutra')
    })
  },
  catalogsPharma: {
    add: getBuFromCatalog,
    delete: getBuFromCatalog,
    globalSearch: ({ data, vm }) => ({
      routeAs: 'add',
      action: searchCatalog(data, vm, 'pharma')
    })
  },
  catalogsChemi: {
    add: getBuFromCatalog,
    delete: getBuFromCatalog,
    globalSearch: ({ data, vm }) => ({
      routeAs: 'add',
      action: searchCatalog(data, vm, 'chemi')
    })
  },
  trends: {
    add: ({ data }) => ({ name: 'TrendsPage', params: { slug: data.slug[0] } }),
    delete: () => ({ name: 'Trends' })
  },
  favorites: {
    add: ({ data }) => ({
      name: 'FavoritesPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'Favorites' })
  },
  documents: {
    fields: ['uuid', { folders: ['uuid', { business_units: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'BuGed',
      params: { slug: data.folders.data[0].business_units.slug[0] },
      query: { folder: data.folders.data[0].uuid }
    }),
    delete: ({ data }) => ({
      name: 'BuGed',
      params: { slug: data.folders.data[0].business_units.slug[0] },
      query: { folder: data.folders.data[0].uuid }
    })
  },
  catalogsFood: {
    add: getBuFromCatalog,
    delete: getBuFromCatalog
  },
  folders: {
    fields: ['uuid', { business_units: ['slug'] }],
    add: ({ data }) => ({
      name: 'BuGed',
      params: { slug: data.business_units.slug[0] },
      query: { folder: data.uuid }
    }),
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/folders', {
          fields: [{ business_units: ['slug'] }],
          filters: { 'uuid:eq': uuid }
        })

        return {
          name: 'BuGed',
          params: { slug: data[0].business_units.slug[0] },
          query: { business_units: data.uuid }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  pages: {
    add: ({ data }) => ({
      name: 'SimplePage',
      params: { slug: data.slug[0] }
    })
  },
  pageCatalogs: {
    fields: [
      {
        bu_highlights: {
          fields: [{ business_units: ['slug'] }],
          filters: { reverse: true }
        }
      }
    ],
    add: ({ data }) =>
      data.bu_highlights && {
        name: 'BuCatalog',
        params: {
          slug: data.bu_highlights?.data?.[0]?.business_units?.slug?.[0]
        }
      }
  },
  buHighlights: {
    fields: [{ business_units: ['slug'] }],
    add: ({ data }) => ({
      name: 'BuPage',
      params: { slug: data.business_units.slug[0] }
    }),
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/bu_highlights', {
          fields: [{ business_units: ['slug'] }],
          filters: { 'uuid:eq': uuid }
        })

        return {
          name: 'BuPage',
          params: { slug: data[0].business_units.slug[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  businessUnits: {
    add: ({ data }) => ({ name: 'BuPage', params: { slug: data.slug[0] } })
  },
  iframePages: {
    fields: [
      'uuid',
      {
        bu_highlights: {
          fields: [{ business_units: ['slug'] }],
          filters: { reverse: true }
        }
      }
    ],
    add: async ({ data }) => {
      try {
        const { data: buData } = await http.get('content/bu_highlights', {
          filters: {
            iframe_pages: {
              'uuid:eq': data.uuid
            }
          },
          fields: [{ business_units: ['slug'] }]
        })

        if (buData.length) {
          return {
            name: 'BuIframes',
            params: { slug: buData[0].business_units.slug[0] }
          }
        }

        return '/'
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  producers: {
    add: async () => {
      try {
        const { data } = await http.get('content/page_catalogs', {
          fields: [
            'uuid',
            {
              bu_highlights: {
                fields: [{ business_units: ['slug'] }],
                filters: { reverse: true }
              }
            }
          ],
          filters: { 'custom_slug:eq': 'catalogs_nutra' }
        })

        return {
          name: 'BuCatalog',
          params: { slug: data[0].bu_highlights.data[0].business_units.slug[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async () => {
      try {
        const { data } = await http.get('content/page_catalogs', {
          fields: [
            'uuid',
            {
              bu_highlights: {
                fields: [{ business_units: ['slug'] }],
                filters: { reverse: true }
              }
            }
          ],
          filters: { 'custom_slug:eq': 'catalogs_nutra' }
        })

        return {
          name: 'BuCatalog',
          params: { slug: data[0].bu_highlights.data[0].business_units.slug[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  }
}
