import Vue from 'vue'

import insideConfig from './inside.config'
import redirections from './redirections'
import routes from './router'

export default {
  name: 'inside-customs',
  displays: {
    'catalog-item-customs': Vue.component('catalog-item-customs', () =>
      import('./components/catalogs/CatalogItemCustoms')
    )
  },
  modals: {
    'catalog-files-upload': Vue.component('catalog-files-upload-modal', () =>
      import('./components/modals/CatalogFilesUploadModal')
    ),
    'catalog-cos': Vue.component('catalog-cos-modal', () =>
      import('./components/modals/CatalogCosModal')
    ),
    'catalog-nutra': Vue.component('catalog-nutra-modal', () =>
      import('./components/modals/CatalogNutraModal')
    ),
    'catalog-pharma': Vue.component('catalog-pharma-modal', () =>
      import('./components/modals/CatalogPharmaModal')
    ),
    'catalog-chemi': Vue.component('catalog-chemi-modal', () =>
      import('./components/modals/CatalogChemiModal')
    ),
    'catalog-food': Vue.component('catalog-food-modal', () =>
      import('./components/modals/CatalogFoodModal')
    ),
    'wrong-lang': Vue.component('wrong-lang-modal', () =>
      import('./components/modals/WrongLangModal')
    )
  },
  config: {
    tabs: {}
  },
  routes,
  insideConfig,
  redirections
}
