import { http } from '@inside-library/helpers/Http'
import { normalizeColor } from '../../helpers'
import {
  capsuleNewsFields,
  categoriesFieldsWithSubCategories
} from '../../constants/news-fields'

const fetchCta = async () => {
  try {
    const { data } = await http.get('content/pages', {
      fields: [
        'uuid',
        'title',
        'introduction',
        'banner',
        'slug',
        'homepage_display'
      ],
      filters: {
        limit: 1,
        'status:eq': 1,
        'homepage_display:eq': 1,
        sort: 'updated_at:desc'
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchFeatured = async () => {
  try {
    const { data } = await http.get('content/favorites,trends', {
      filters: {
        'status:eq': 1,
        'is_featured:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 3
      },
      fields: [
        ...capsuleNewsFields,
        { categories: categoriesFieldsWithSubCategories }
      ]
    })

    return normalizeColor(data)
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchFeatured, fetchCta }
