export default {
  // GED
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },

  // USERS
  users: {
    modalFields: ['uuid', 'image', 'firstname', 'lastname', 'email', 'phone']
  },

  // CATALOGUE COSMÉTIQUE
  catalogs_cos: {
    modalFields: [
      'uuid',
      'content_type',
      'title',
      'inci',
      'image',
      'active_materials',
      'absorptions',
      'appearances',
      'benefits',
      'color',
      'description',
      'families',
      'forms',
      'content',
      'granulometries',
      'hlb',
      'product_informations',
      'naturalities',
      'chemical_natures',
      'geographical_origins',
      'optimal_ph',
      'melting_points',
      'solvent',
      'specificities',
      'status_nano',
      'conservative_system',
      'size',
      'aggregate_size',
      'particles_size',
      'technologies',
      'treatment',
      'pigment_type',
      'main_claims',
      'hair_skin',
      'applications_cos',
      'solubility_dispersion',
      'level_use',
      {
        business_units: [
          'uuid',
          'title',
          { colors: ['uuid', 'color'] },
          {
            sales_managers: [
              'uuid',
              'image',
              'firstname',
              'lastname',
              'email',
              'phone',
              'mobile'
            ]
          }
        ]
      },
      {
        certif_conformities: {
          fields: ['uuid', 'title', 'image'],
          filters: { 'show_field:eq': 1 }
        }
      },
      { functions: ['uuid', 'title'] },
      { suppliers: ['uuid', 'title', 'image'] },
      { properties: ['uuid', 'title'] }
    ]
  },

  // CATALOGUE NUTRA
  catalogs_nutra: {
    modalFields: [
      'uuid',
      'content_type',
      'title',
      'image',
      'description',
      'promises',
      'content',
      'active_1',
      'active_2',
      'active_3',
      'active_4',
      'active_content_1',
      'active_content_2',
      'active_content_3',
      'active_content_4',
      'recommended_dosages',
      'certificates',
      'forms',
      'advantages',
      {
        business_units: [
          'uuid',
          'title',
          { colors: ['uuid', 'color'] },
          {
            sales_managers: [
              'uuid',
              'image',
              'firstname',
              'lastname',
              'email',
              'phone',
              'mobile'
            ]
          }
        ]
      },
      { ingredient_categories: ['uuid', 'title'] },
      { health_benefits: ['uuid', 'title'] },
      { botanical_name: ['uuid', 'title'] },
      { producers: ['uuid', 'title', 'image'] }
    ]
  },

  // CATALOGUE PHARMA
  catalogs_pharma: {
    modalFields: [
      'uuid',
      'content_type',
      'title',
      'image',
      'catchphrase',
      'apyrogenics',
      'characteristics',
      'cas',
      'standard_containers',
      'image_credits',
      'description',
      'formulas',
      'mw',
      'trade_name',
      'origins',
      'pharmacopoeias',
      'controlled_substances',
      'content',
      'producer',
      {
        business_units: [
          'uuid',
          'title',
          { colors: ['uuid', 'color'] },
          {
            sales_managers: [
              'uuid',
              'image',
              'firstname',
              'lastname',
              'email',
              'phone',
              'mobile'
            ]
          }
        ]
      },
      { categories: ['uuid', 'title'] },
      { features: ['uuid', 'title'] },
      { production_processes: ['uuid', 'title'] },
      { administration_routes: ['uuid', 'title'] },
      { dosage_forms: ['uuid', 'title'] }
    ]
  },

  // CATALOGUE CHIMIE
  catalogs_chemi: {
    modalFields: [
      'uuid',
      'content_type',
      'title',
      'image',
      'number_cas',
      'description',
      'delivery_form',
      'dry_active_matter',
      'color_index',
      'tmff',
      'tg',
      'molecular_weight',
      'ph',
      'regulatory',
      'content',
      {
        business_units: [
          'uuid',
          'title',
          { colors: ['uuid', 'color'] },
          {
            sales_managers: [
              'uuid',
              'image',
              'firstname',
              'lastname',
              'email',
              'phone',
              'mobile'
            ]
          }
        ]
      },
      { functions_chemistry: ['uuid', 'title'] },
      { suppliers_chemistry: ['uuid', 'title', 'image'] },
      { country_distribution: ['uuid', 'title'] },
      { chemistry: ['uuid', 'title'] },
      { country_origin: ['uuid', 'title'] },
      { systems: ['uuid', 'title'] },
      { applications: ['uuid', 'title'] },
      { biosourced: ['uuid', 'title'] }
    ]
  },

  // CATALOGUE FOOD
  catalogs_food: {
    modalFields: [
      'uuid',
      'content_type',
      'title',
      'generic_benefits',
      'fat_percentage',
      'fat_type',
      'mesh',
      'content',
      'formulation_sheet',
      'distribution_country',
      'producers_food',
      {
        business_units: [
          'uuid',
          'title',
          { colors: ['uuid', 'color'] },
          {
            sales_managers: [
              'uuid',
              'image',
              'firstname',
              'lastname',
              'email',
              'phone',
              'mobile'
            ]
          }
        ]
      },
      { product_type: ['uuid', 'title', 'image'] },
      { recommended_app_func: ['uuid', 'title'] },
      { segments: ['uuid', 'title'] },
      { food_applications: ['uuid', 'title'] },
      { ingredients_specialties: ['uuid', 'title'] }
    ]
  }
}
