<?php

namespace Inside\UNIP\Console;

use Illuminate\Console\Command;
use Inside\Host\Bridge\BridgeContent;

class DeleteContentCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:content:delete';

    /**
     * @var string
     */
    protected $signature = 'inside:content:delete { type? : Type of import to be executed} {--l|langcode=}';

    /**
     * @var string
     */
    protected $description = 'Delete all content';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function handle(): void
    {
        $bridge  = new BridgeContent();
        /** @var string $type */
        $type = $this->argument('type');
        $langcode = $this->option('langcode');

        $query = call_user_func(type_to_class($type) . '::query');
        if ($langcode) {
            $query->where('langcode', $langcode);
        }
        $contents = $query->get();
        foreach ($contents as $value) {
            $bridge->contentDelete($type, $value->uuid);
        }
    }
}
