<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\CatalogsCos;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class RefactoFieldInci extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        $bridge = new BridgeContent();

        $catalogsCos = CatalogsCos::all('uuid', 'inci', 'title');

        $bridgeType->contentTypeDeleteField('node', 'catalogs_cos', 'inci');
        $bridgeType->contentTypeCreateOrUpdateField(
            'catalogs_cos',
            'inci',
            [
                'name' => 'inci',
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'INCI',
                    'en' => 'INCI'
                ],

                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );

        foreach ($catalogsCos as $item) {
            $bridge->contentUpdate('catalogs_cos', [
                'bundle' => 'catalogs_cos',
                'title' => $item->title,
                'uuid' => $item->uuid,
                'inci' => $item->inci
            ]);
        }
    }

    public function down(): void
    {
    }
}
