<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class TranslationContentType extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();

        $contentTypes = [
            'botanical_name' => [
                'title' => [
                    'fr' => 'Nom botanique',
                    'en' => 'Botanical name'
                ],
            ],
            'bu_highlights' => [
                'title' => [
                    'fr' => 'Mises en avant Business Unit',
                    'en' => 'Business Unit Highlights'
                ],
            ],
            'business_units' => [
                'title' => [
                    'fr' => 'Business Unit',
                    'en' => 'Business Units'
                ],
            ],
            'catalogs_cos' => [
                'title' => [
                    'fr' => 'Fiche produit cosmétique',
                    'en' => 'Cosmetics item'
                ],
            ],
            'catalogs_nutra' => [
                'title' => [
                    'fr' => 'Fiche produit nutra',
                    'en' => 'Nutra item'
                ],
            ],
            'catalogs_pharma' => [
                'title' => [
                    'fr' => 'Fiche produit pharma',
                    'en' => 'Pharma item'
                ],
            ],
            'categories' => [
                'title' => [
                    'fr' => 'Catégorie',
                    'en' => 'Categorie'
                ],
            ],
            'certif_conformities' => [
                'title' => [
                    'fr' => 'Certifications et conformités',
                    'en' => 'Certifications and Conformities'
                ],
            ],
            'colors' => [
                'title' => [
                    'fr' => 'Couleurs',
                    'en' => 'Colors'
                ],
            ],
            'documents' => [
                'title' => [
                    'fr' => 'Documents BU',
                    'en' => 'BU documents'
                ],
            ],
            'dosage_forms' => [
                'title' => [
                    'fr' => 'Forme galénique',
                    'en' => 'Dosage form'
                ],
            ],
            'favorites' => [
                'title' => [
                    'fr' => 'Coups de coeur',
                    'en' => 'Favourites'
                ],
            ],
            'favorites_categories' => [
                'title' => [
                    'fr' => 'Catégories de coups de coeurs',
                    'en' => 'Favorite categories'
                ],
            ],
            'features' => [
                'title' => [
                    'fr' => 'Fonctionnalité',
                    'en' => 'Feature'
                ],
            ],
            'folders' => [
                'title' => [
                    'fr' => 'Dossiers BU',
                    'en' => 'BU folders'
                ],
            ],
            'functions' => [
                'title' => [
                    'fr' => 'Fonction',
                    'en' => 'Function'
                ],
            ],
            'health_benefits' => [
                'title' => [
                    'fr' => 'Bénéfices santé',
                    'en' => 'Health benefits'
                ],
            ],
            'iframe_pages' => [
                'title' => [
                    'fr' => 'Page iframe',
                    'en' => 'Page iframe'
                ],
            ],
            'ingredient_categories' => [
                'title' => [
                    'fr' => 'Catégories d\'ingrédients',
                    'en' => 'Ingredient categories'
                ],
            ],
            'page_catalogs' => [
                'title' => [
                    'fr' => 'Pages catalogue',
                    'en' => 'Catalog pages'
                ],
            ],
            'producers' => [
                'title' => [
                    'fr' => 'Producteurs',
                    'en' => 'Producers'
                ],
            ],
            'production_processes' => [
                'title' => [
                    'fr' => 'Process de production du médicament',
                    'en' => 'Drug production process'
                ],
            ],
            'properties' => [
                'title' => [
                    'fr' => 'Propriétés',
                    'en' => 'Properties'
                ],
            ],
            'suppliers' => [
                'title' => [
                    'fr' => 'Fournisseurs',
                    'en' => 'Suppliers'
                ],
            ],
            'trends' => [
                'title' => [
                    'fr' => 'Tendances',
                    'en' => 'Trends'
                ],
            ],
            'trends_categories' => [
                'title' => [
                    'fr' => 'Catégories de tendances',
                    'en' => 'Trends categories'
                ],
            ],
            'users' => [
                'title' => [
                    'fr' => 'Utilisateurs',
                    'en' => 'Users'
                ],
            ],
        ];

        $translation = [
            'Bannière' => 'Banner',
            'Image' => 'Image',
            'Est mis en avant ?' => 'Is put forward ?',
            'Catégorie' => 'Category',
            'Catégorie parente' => 'Parent category',
            'Catégorie de coups de coeur' => 'Favorite Category',
            'Catégorie de tendances' => 'Trend Category',
            'Couleur' => 'Color',
            'Introduction' => 'Introduction',
            'Nom court' => 'Short name',
            'Authors' => 'Auteur',
            'Fichier' => 'File',
            'Type de contenu du catalogue' => 'Type of content in the catalog',
            'Mettre en avant sur la page d’accueil	' => 'Highlight on the home page',
            'Contenu' => 'Content',
            'Chapô' => 'Chapô',
            'Business Unit' => 'Business Unit',
            'Ordre d\'affichage' => 'Display order',
            'Pages' => 'Pages',
            'Pages catalogue' => 'Catalog pages',
            'Pages iframe' => 'Iframe pages',
            'Redirection CTA' => 'CTA redirection',
            'Titre CTA' => 'Title CTA',
            'Dossier parent' => 'Parent folder',
            'Image de prévisualisation' => 'Preview image',
            'Est-ce un dossier de médiathèque ?' => 'Is this a media library file ?',
            'Picto' => 'Pictogram',
            // catalogs pharma
            'Accroche' => 'Advertissement',
            'CAS' => 'CAS',
            'Apyrogène' => 'Non-pyrogenic',
            'Contenant standard' => 'Standard Packaging',
            'Crédit photo' => 'Crédit photo',
            'Description' => 'Description',
            'Fonctionnalité' => 'Functionality',
            'Forme galénique' => 'Galeniq form',
            'Formule' => 'Formula',
            'Mw' => 'Mw',
            'Nom commercial' => 'Nom commercial',
            'Origine' => 'Origin',
            'Pharmacopées' => 'Pharmacopeia',
            'Photo de la molécule' => 'Picture of the molcule',
            'Process de production du médicament' => 'Production process of the medecine',
            'Producteur' => 'Producer',
            'Substance contrôlée' => 'Controlled substance',
            'Voie d\'administration' => 'Route of administration',
            // catalogs nutra
            'Actif 1' => 'Active 1',
            'Actif 2' => 'Active 2',
            'Actif 3' => 'Active 3',
            'Actif 4' => 'Active 4',
            'Teneur en actif 1' => 'Content of active 1',
            'Teneur en actif 2' => 'Content of active 2',
            'Teneur en actif 3' => 'Content of active 3',
            'Teneur en actif 4' => 'Content of active 4',
            'Avantages' => 'Benefits',
            'Bénéfices Santé' => 'Health benefits',
            'Catégorie d\'ingrédient' => 'Category of ingredients',
            'Certificats' => 'Certificats',
            'Dosage recommandé / jour' => 'Recommended dosage / day',
            'Forme' => 'Form',
            'Nom botanique' => 'Botanical name',
            'Promesses' => 'Promises / Claim ?',
            // catalogs cos
            '% matière active' => '% of active ingredient',
            'Absorption' => 'Absorption',
            'Apparence' => 'Appearance',
            'Bénéfices' => 'Benefits',
            'Certifications et conformités' => 'Certifications and Conformities',
            'Famille' => 'Family',
            'Fonction' => 'Function',
            'Formules associées' => 'Associated formula',
            'Fournisseur' => 'Supplier',
            'Granulométrie' => 'Granulometry',
            'HLB' => 'HLB',
            'INCI' => 'INCI',
            'Information produit' => 'Product information',
            'Naturalité' => 'Naturality',
            'Nature chimique' => 'Chemical nature',
            'Origine géographique' => 'Geographic origin',
            'pH optimal' => 'Optimal pH',
            'Point de fusion' => 'Melting point',
            'Propriétés' => 'Properties',
            'Solvant' => 'Solvent',
            'Spécificité' => 'Specificity',
            'Statut nano/non nano' => 'Nano / Non-Nano status',
            'Système conservateur' => 'Preservative system',
            'Taille (mm)' => 'Size',
            'Taille agrégats' => 'Aggregate size',
            'Taille particule' => 'Particle size',
            'Technologie' => 'Technology',
            'Traitement' => 'Treatment',
            'Type de pigment' => 'Pigment type',
        ];

        foreach ($contentTypes as $machineName => $translationNameContentType) {
            $bridgeType->contentTypeUpdate($machineName, $translationNameContentType);
            foreach (InsideSchema::getDisplayedFieldListing($machineName) as $fieldName) {
                $fieldOptions = InsideSchema::getFieldOptions($machineName, $fieldName);
                foreach ($translation as $key => $trad) {
                    if ($fieldOptions['title']['fr'] === $key) {
                        //dd($machineName, $fieldName, $key, $trad);
                        $bridgeType->changeFieldTitle($machineName, $fieldName, ['en' => $trad, 'fr' => $key]);
                    }
                }
            }
        }
    }

    public function down(): void
    {
    }
}
