<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RefactoFieldCtaLink extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'bu_highlights', 'cta_link');
        $bridge->contentTypeDeleteField('node', 'bu_highlights', 'cta_title');

        $bridge->contentTypeCreateOrUpdateField('bu_highlights', 'cta_title', [
            'name' => 'cta_title',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Titre CTA',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 3,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('bu_highlights', 'cta_link', [
            'name' => 'cta_link',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'required' => true,
            'weight' => 8,
            'title' => [
                'fr' => 'Redirection CTA',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 8,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
