<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateContentType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $this->bootUp(__FILE__);
        $this->migrateContent('bu_highlights');
        $this->finishUp();

        $bridge->contentTypeDeleteField('node', 'folders', 'image');
        $bridge->contentTypeDelete('featured');

        // business_units migration
        $bridge->contentTypeCreateOrUpdateField('business_units', 'name_shortcuts', [
            'name' => 'name_shortcuts',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Nom',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 4,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('business_units', 'sales_managers', [
            'name' => 'sales_managers',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Responsable commercial',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'weight' => 5,
            ],
            'settings' => [
                'target_type' => ['users'],
                'cardinality' => 1,
            ],
        ]);

        // Folders migration
        $bridge->contentTypeCreateOrUpdateField('folders', 'business_units', [
            'name' => 'business_units',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Business Unit',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => 5,
            ],
            'settings' => [
                'target_type' => ['business_units'],
                'cardinality' => -1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('folders', 'icon', [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Picto',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('folders', 'image', [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ]);

        // Users migration
        $bridge->contentTypeCreateOrUpdateField('users', 'business_units', [
            'name' => 'business_units',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 9,
            'title' => [
                'fr' => 'Business Unit',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => 9,
            ],
            'settings' => [
                'target_type' => ['business_units'],
                'cardinality' => -1,
            ],
        ]);

        // Documents Migration
        $bridge->contentTypeCreateOrUpdateField('documents', 'business_units', [
            'name' => 'business_units',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Business Unit',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => 5,
            ],
            'settings' => [
                'target_type' => ['business_units'],
                'cardinality' => -1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
