<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;
// todo : new fields should not be filters

return [
    'options' => [
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'name' => 'catalogs_cos',
        'title' => [
            'fr' => 'Fiche produit cosmétique',
            'en' => 'Cosmetics item',
        ],
    ],
    'fields' => [
        [
            'name' => 'main_claims',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'title' => [
                'en' => 'Main claims',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'main_claims',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'hair_skin',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'title' => [
                'en' => 'Hair / Skin',
                'fr' => 'Cheveux / Peau',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'hair_skin',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'applications_cos',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'title' => [
                'fr' => 'Application cosmétique',
                'en' => 'Cosmetics application',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'applications_cos',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'solubility_dispersion',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Famille',
                'en' => 'Solubility or dispersion',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'level_use',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'en' => '% level of use',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ]
];
