<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'name' => 'bu_highlights',
        'title' => [
            'fr' => 'Mises en avant Business Unit',
            'en' => 'Business Unit highlights'
        ],
    ],
    'fields' => [
        [
            'name' => 'iframe_pages',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Pages iframe',
                'en' => 'Iframe pages'
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['iframe_pages'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'pages',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Pages',
                'en' => 'Pages',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['pages'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'custom',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Page personnalisé',
                'en' => 'Custom page',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['custom'],
                'cardinality' => 1,
            ],
        ]
    ]
];
