<?php

use Illuminate\Database\Query\Builder;
use Illuminate\Support\Str;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Markets;
use Inside\Host\Bridge\BridgeContent;
use Inside\User\Models\User;

if (!function_exists('get_string')) {
    function get_string(array $record, string $column): ?string
    {
        if (array_key_exists($column, $record) && !empty(trim($record[$column]))) {
            return trim($record[$column]);
        }

        return null;
    }
}

if (!function_exists('get_or_insert_reference')) {
    function get_or_insert_reference(Builder $query, string $name, string $bundle, BridgeContent $bridge, bool $insertNew = true): ?array
    {
        if ($bundle === 'business_units') {
            $entity = $query->where('name_shortcuts', $name)->first();
        } else {
            $entity = $query->where('title', $name)->first();
        }

        /** @var Content|null $entity */
        if ($entity) {
            return [$entity->uuid];
        }

        if (!$insertNew) {
            return null;
        }

        $uuidBridge = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle,
        ]);

        if ($uuidBridge) {
            return [$uuidBridge];
        }

        return null;
    }
}

if (!function_exists('get_entity')) {
    function get_entity(array $record, \Inside\Host\Bridge\BridgeContent $bridge, string $bundle, string $column, string $langcode = null, bool $insertNew = true): ?array
    {
        if (!array_key_exists($column, $record)) {
            return null;
        }
        $name = trim($record[$column]);
        if (empty($name)) {
            return null;
        }
        $query = call_user_func('Inside\\Content\\Models\\Contents\\' . \Illuminate\Support\Str::studly($bundle) . '::get');

        if ($langcode) {
            $query->where('langcode', $langcode);
        }

        if (Str::contains($name, "\n")) {
            $dataUuid = [];
            $names = explode("\n", $name);
            foreach ($names as $name) {
                $uuidReference = get_or_insert_reference($query, trim($name), $bundle, $bridge, $insertNew);

                if (empty($uuidReference)) {
                    continue;
                }

                $dataUuid = array_merge($dataUuid, $uuidReference);
            }

            return $dataUuid;
        }

        return get_or_insert_reference($query, trim($name), $bundle, $bridge, $insertNew);
    }
}

return [
    'manual' => [
        'disable' => false,
    ],
    'files' => [
        'unip' => [
            'path' => __DIR__ . '/../../../../imports/import.csv',
            'separator' => ';',
            'fields' => [
                'name' => function ($record) {
                    return trim($record['email']);
                },
                'mail' => function ($record) {
                    return trim($record['email']);
                },
                'firstname' => function ($record) {
                    return ucwords($record['prénom']);
                },
                'lastname' => function ($record) {
                    return ucwords($record['nom']);
                },
                'phone' => function ($record) {
                    return get_string($record, 'téléphone');
                },
                'companies' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'companies', 'société');
                },
                'departments' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'departments', 'département');
                },
                'business_units' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    $langcode = trim(strtolower($record['langue']));

                    $langcode = in_array($langcode, ['fr', 'en']) ? $langcode : 'fr';

                    return get_entity($record, $bridge, 'business_units', 'espaces bu', $langcode, false);
                },
                'bu_sources' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    $langcode = trim(strtolower($record['langue']));

                    $langcode = in_array($langcode, ['fr', 'en']) ? $langcode : 'fr';
                    return get_entity($record, $bridge, 'business_units', 'bu d\'origine', $langcode, false);
                },
                'status' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    $langcode = trim(strtolower($record['langue']));

                    return in_array($langcode, ['fr', 'en']) ? 1 : 0;
                },
                'langcode' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    $langcode = trim(strtolower($record['langue']));

                    return in_array($langcode, ['fr', 'en']) ? $langcode : 'fr';
                },
                'markets' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    $langcode = trim(strtolower($record['langue']));

                    if (!in_array($langcode, ['fr', 'en'])) {
                        return null;
                    }

                    $query = Markets::query()->where('langcode', $langcode);

                    /** @var User|null $user */
                    $user = User::query()->where('email', trim($record['email']))->first();

                    if (!$user || !$user->hasAnyRole('super_administrator')) {
                        $name = $langcode === 'fr' ? 'fr' : 'bnl';
                        $query->where('machine_name', $name);
                    }

                    $markets = $query->pluck('uuid')->toArray();

                    if (empty($markets)) {
                        return null;
                    }

                    return $markets;
                },
                'send_mail' => function () {
                    return 1;
                },
            ]
        ]
    ],
    'cleandata' => function (&$data) {
        if ($data['image'] === false) {
            unset($data['image']);
        }
    }
];
