<?php

namespace Inside\UNIP\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\UNIP\Console\DeleteContentCommand;
use Inside\UNIP\Console\ImportCsvCommand;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * UNIP Service provider.
 *
 * @category Class
 * @package  Inside\UNIP\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $commands = [
        ImportCsvCommand::class,
        DeleteContentCommand::class,
    ];

    public function boot(): void
    {
        parent::boot();

        config([
            'catalogue.filters.hidden_rules' => [
                function ($key, $filters) {
                    if ($key == 'properties' && !$filters->has('functions')) {
                        return true;
                    }
                    return false;
                },
            ],
        ]);
    }

    public function register(): void
    {
        try {
            $this->mergeConfigFrom(__DIR__.'/../../config/catalogs.php', 'catalogs');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
