<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class SetFirstAndLastNameFieldsToNullable extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('inside_users')) {
            return;
        }

        $bridge = new BridgeContentType();

        if (Schema::hasColumn('inside_content_users', 'firstname')) {
            $bridge->contentTypeUpdateField('users', 'firstname', ['required' => false]);
        }

        if (Schema::hasColumn('inside_content_users', 'lastname')) {
            $bridge->contentTypeUpdateField('users', 'lastname', ['required' => false]);
        }
    }
}
