<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Search\Facades\Searchable;

class UpdateFilterQueryModeOnCatalog extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /** @var array */
    protected $catalog = [
        'catalogs_cos' => [
            'certif_conformities',
            'properties',
        ],
        //     'catalogs_nutra',
        //    'catalogs_pharma',
    ];

    /** @var array */
    protected $fieldNames = [

    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        foreach ($this->catalog as $type => $fieldNames) {
            foreach ($fieldNames as $fieldName) {
                $bridge->updateFieldOptions($type, $fieldName, [
                    'filter_query_mode' => Searchable::OPERATOR_AND,
                ]);
            }
        }
    }

    public function down(): void
    {
    }
}
