<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateFieldShowField extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'certif_conformities',
            'show_field',
            [
                'name' => 'show_field',
                'searchable' => false,
                'translatable' => true,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Le champ remonte dans la modale ?',
                    'en' => 'The field goes up in the modal?'
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 2,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
