<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class BuHighLightsRefacto extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $this->bootUp(__FILE__);
        $this->migrateContent('page_catalogs');
        $this->finishUp();

        $bridge->contentTypeDeleteField('node', 'bu_highlights', 'custom');
        $bridge->contentTypeCreateOrUpdateField(
            'bu_highlights',
            'page_catalogs',
            [
                'name' => 'page_catalogs',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => true,
                'title' => [
                    'fr' => 'Pages catalogue',
                    'en' => 'Catalog pages'
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                ],
                'settings' => [
                    'target_type' => ['page_catalogs'],
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
