<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldFile extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'catalogs_nutra',
            'botanical_questionnaires',
            [
                'name' => 'botanical_questionnaires',
                'type' => BridgeContentType::FILE_FIELD,
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Questionnaire Botanique',
                    'en' => 'Botanical Questionnaires',
                ],
                'widget' => [
                    'type' => BridgeContentType::FILE_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
        $bridge->contentTypeCreateOrUpdateField(
            'catalogs_nutra',
            'clinical_studies',
            [
                'name' => 'clinical_studies',
                'type' => BridgeContentType::FILE_FIELD,
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Etudes cliniques',
                    'en' => 'Clinical studies',
                ],
                'widget' => [
                    'type' => BridgeContentType::FILE_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
        $bridge->contentTypeCreateOrUpdateField(
            'catalogs_nutra',
            'brochures_link',
            [
                'name' => 'brochures_link',
                'type' => BridgeContentType::FILE_FIELD,
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Lien Brochures',
                    'en' => 'Brochures link',
                ],
                'widget' => [
                    'type' => BridgeContentType::FILE_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
        $bridge->contentTypeCreateOrUpdateField(
            'catalogs_nutra',
            'published_articles',
            [
                'name' => 'published_articles',
                'type' => BridgeContentType::FILE_FIELD,
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Articles paru dans Actif Magazine ou autres',
                ],
                'widget' => [
                    'type' => BridgeContentType::FILE_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
