<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateCatalogsAndBu extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'catalogs_nutra', 'producers');
        $bridge->contentTypeDeleteField('node', 'catalogs_pharma', 'image_molecule');
        $bridge->contentTypeDeleteField('node', 'catalogs_pharma', 'features');
        $bridge->contentTypeDeleteField('node', 'catalogs_cos', 'associated_formulas');
        $bridge->contentTypeDeleteField('node', 'catalogs_cos', 'features');
        $bridge->contentTypeDeleteField('node', 'bu_highlights', 'cta_content');
        $bridge->updateFieldOptions('catalogs_cos', 'image', ['required' => false]);

        $this->bootUp(__FILE__);
        $this->migrateContent('dosage_forms');
        $this->migrateContent('iframe_pages');
        $this->migrateContent('producers');
        $this->migrateContent('functions');
        $this->migrateContent('features');
        $this->migrateContent('catalogs_nutra');
        $this->migrateContent('catalogs_pharma');
        $this->migrateContent('catalogs_cos');
        $this->migrateContent('bu_highlights');
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
