<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RefactoContentTypeBuHighlights extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'bu_highlights', 'cta_icon');
        $bridge->contentTypeCreateOrUpdateField('bu_highlights', 'cta_file', [
            'name' => 'cta_file',
            'searchable' => true,
            'translatable' => true,
            'default' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Fichier',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ]);
        $bridge->contentTypeCreateOrUpdateField('bu_highlights', 'cta_content', [
            'name' => 'cta_content',
            'searchable' => true,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Lien interne',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['pages'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
