<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'name' => 'catalogs_pharma',
        'title' => [
            'fr' => 'Fiche produit pharma',
            'en' => 'Pharma item',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Photo de la molécule',
                'en' => 'Photo of the molecule'
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'dosage_forms',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget' => 'checkboxesgroup',
            'filter_order' => 1,
            'filter_category' => '',
            'required' => true,
            'title' => [
                'fr' => 'Forme galénique',
                'en' => 'Dosage forms',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'dosage_forms',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'features',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget' => 'checkboxesgroup',
            'filter_order' => 1,
            'filter_category' => '',
            'required' => false,
            'title' => [
                'fr' => 'Fonctionnalité',
                'en' => 'Features',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'features',
                'cardinality' => -1,
            ],
        ],
    ]
];
