<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'name' => 'catalogs_nutra',
        'title' => [
            'fr' => 'Fiche produit nutra',
            'en' => 'Nutra item',
        ],
    ],
    'fields' => [
        [
            'name' => 'producers',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'required' => true,
            'title' => [
                'fr' => 'Producteur',
                'en' => 'Producers',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'producers',
                'cardinality' => -1,
            ],
        ],
    ]
];
