<?php

use Inside\Content\Models\Contents\SpaceFolders;
use Inside\Content\Models\Contents\SharedFolders;

return [
    'locked' => [],
    'global_scope' => function ($builder, $user, $model) {
        $markets = $user->information->markets;
        $langcodes = [];

        foreach ($markets as $market) {
            switch ($market->machine_name) {
                case 'bnl':
                    $langcodes[] = 'en';
                    break;
                case 'fr':
                    $langcodes[] = 'fr';
                    break;
            }
        }

        if (empty($langcodes)) {
            $langcodes = ['none'];
        }

        $builder->whereIn($model->getTable() . '.langcode', $langcodes);
    }
];
