<?php

use Illuminate\Support\Str;
use Inside\UNIP\Facades\ImportCsv;

function manage_language_import(string $fr, string $en, string $langcode): string
{
    return $langcode === 'fr' ? $fr : $en;
}

return [
    'authorize_type' => [
        'cos',
        'nutra',
        'pharma',
        'chemi',
        'food'
    ],
    'cos' => [
        'type' => function () {
            return 'node';
        },
        'bundle' => function () {
            return 'catalogs_cos';
        },
        'description' => function ($record) {
            return Str::ucfirst(trim($record['description']));
        },
        'hlb' => function ($record) {
            return Str::ucfirst(trim($record['hlb']));
        },
        'title' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('nom commercial', 'trade name', $langcode)]));
        },
        'inci' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('inci', 'inci name', $langcode)]));
        },
        'chemical_natures' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('nature chimique', 'chemistry', $langcode)]));
        },
        'melting_points' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('point de fusion', 'melting point', $langcode)]));
        },
        'naturalities' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('naturalité', 'naturality', $langcode)]));
        },
        'solvent' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('solvant', 'solvent', $langcode)]));
        },
        'technologies' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('technologie', 'techology', $langcode)]));
        },
        'optimal_ph' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('ph optimal', 'ph', $langcode)]));
        },
        'forms' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('forme', 'form', $langcode)]));
        },
        'color' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('couleur', 'color product', $langcode)]));
        },
        'families' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('famille', 'family', $langcode)]));
        },
        'active_materials' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('% de matière active', '% of active ingredient', $langcode)]));
        },
        'specificities' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('spécificité', 'spécificity', $langcode)]));
        },
        'size' => function ($record, $langcode) {
            return $record[manage_language_import('taille', 'size', $langcode)];
        },
        'properties' => function ($record, $langcode) {
            $value = [
                $record['propriété'], $record[manage_language_import('transparence', 'clarity', $langcode)],
                $record['suspension'], $record[manage_language_import('gélifiant/epaissisant', 'thickening / gelifying', $langcode)],
                $record['emollient'], $record['couleur produit'], $record['type'], $record['nature'], $record['origin']
            ];
            return ImportCsv::getEntityReference($record, 'properties', $value, $langcode, false);
        },
        'certif_conformities' => function ($record, $langcode, $valueReference) {
            return ImportCsv::getEntityReference($record, 'certif_conformities', $valueReference, $langcode, true);
        },
        'functions' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'functions', manage_language_import('fonction', 'function', $langcode), $langcode, false);
        },
        'suppliers' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'suppliers', manage_language_import('fournisseur', 'supplier', $langcode), $langcode, true);
        },
        'image' => function ($record, $langcode) {
            return ImportCsv::getAndUploadImageAndFile(trim($record[manage_language_import('visuel produit', 'visual product', $langcode)]), false);
        },
        'business_units' => function ($record, $langcode) {
            if (isset($record['bu'])) {
                return ImportCsv::getEntityReference($record, 'business_units', 'bu', $langcode, false);
            }
            return ImportCsv::setBusinessUnit(manage_language_import('Espace cosmétique', 'Cosmetics space', $langcode), $langcode);
        },
        'content' => function ($record, $langcode) {
            if (empty($record[manage_language_import('formules associées', 'formulation sheet / technical documentation', $langcode)])) {
                return null;
            }
            return ImportCsv::manageParagraphForData($record[manage_language_import('formules associées', 'formulation sheet / technical documentation', $langcode)]);
        },
    ],
    'nutra' => [
        'type' => function () {
            return 'node';
        },
        'bundle' => function () {
            return 'catalogs_nutra';
        },
        'title' => function ($record) {
            return Str::ucfirst(trim($record['nom commercial']));
        },
        'active_1' => function ($record) {
            return Str::ucfirst(trim($record['actifs 1']));
        },
        'active_content_1' => function ($record) {
            return Str::ucfirst(trim($record['teneur en actifs 1']));
        },
        'active_2' => function ($record) {
            return Str::ucfirst(trim($record['actifs 2']));
        },
        'active_content_2' => function ($record) {
            return Str::ucfirst(trim($record['teneur en actifs 2']));
        },
        'active_3' => function ($record) {
            return Str::ucfirst(trim($record['actifs 3']));
        },
        'active_content_3' => function ($record) {
            return Str::ucfirst(trim($record['teneur en actifs 3']));
        },
        'active_4' => function ($record) {
            return Str::ucfirst(trim($record['actifs 4']));
        },
        'active_content_4' => function ($record) {
            return Str::ucfirst(trim($record['teneur en actifs 4']));
        },
        'advantages' => function ($record) {
            return Str::ucfirst(trim($record['avantages']));
        },
        'promises' => function ($record) {
            return Str::ucfirst(trim($record['promesses']));
        },
        'description' => function ($record) {
            return Str::ucfirst(trim($record['description']));
        },
        'certificates' => function ($record) {
            return Str::ucfirst(trim($record['certificats']));
        },
        'recommended_dosages' => function ($record) {
            return Str::ucfirst(trim($record['dosage recommandé / jour']));
        },
        'forms' => function ($record) {
            return Str::ucfirst(trim($record['forme']));
        },
        'producers' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'producers', 'producteur', $langcode, true);
        },
        'health_benefits' => function ($record, $langcode, $valueReference) {
            return ImportCsv::getEntityReference($record, 'health_benefits', $valueReference, $langcode, false);
        },
        'ingredient_categories' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'ingredient_categories', 'catégorie d\'ingrédients', $langcode, false);
        },
        'botanical_name' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'botanical_name', 'nom botanique', $langcode, false);
        },
        'image' => function ($record) {
            return ImportCsv::getAndUploadImageAndFile(trim($record['nom du visuel']), false);
        },
        'content' => function ($record) {
            return ImportCsv::manageParagraphForData($record, [
                'etudes cliniques' => $record['etudes cliniques'],
                'articles parus dans actif magazine ou autres' => $record['articles parus dans actif magazine ou autres'],
                'lien brochures' => $record['lien brochures'],
                'questionnaire botanique' => $record['questionnaire botanique']
            ]);
        },
    ],
    'pharma' => [
        'type' => function () {
            return 'node';
        },
        'bundle' => function () {
            return 'catalogs_pharma';
        },
        'cas' => function ($record) {
            return Str::ucfirst(trim($record['cas']));
        },
        'mw' => function ($record) {
            return Str::ucfirst(trim($record['mw']));
        },
        'description' => function ($record) {
            return Str::ucfirst(trim($record['description']));
        },
        'title' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('nom chimique', 'chemical name', $langcode)]));
        },
        'trade_name' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('nom commercial', 'trade name', $langcode)]));
        },
        'catchphrase' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('accroche', 'advertissement', $langcode)]));
        },
        'apyrogenics' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('apyrogène', 'non-pyrogenic', $langcode)]));
        },
        'characteristics' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('caractéristiques', 'characteristic', $langcode)]));
        },
        'standard_containers' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('contenant standard', 'standard packaging', $langcode)]));
        },
        'image_credits' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('crédit photo', 'photo credit', $langcode)]));
        },
        'formulas' => function ($record, $langcode) {
            return str_replace(['0','1','2','3','4','5','6','7','8','9'], ['₀','₁','₂','₃','₄','₅','₆','₇','₈','₉'], trim($record[manage_language_import('formule', 'formula', $langcode)]));
        },
        'origins' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('origine', 'origin', $langcode)]));
        },
        'pharmacopoeias' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('pharmacopées', 'pharmacopeia', $langcode)]));
        },
        'controlled_substances' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('substance contrôlée', 'controlled substance', $langcode)]));
        },
        'features' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'features', manage_language_import('fonctionnalité', 'functionality', $langcode), $langcode, false);
        },
        'production_processes' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'production_processes', manage_language_import('process de production du médicament', 'production process of the medecine', $langcode), $langcode, false);
        },
        'categories' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'categories', manage_language_import('catégorie', 'category', $langcode), $langcode, false);
        },
        'administration_routes' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'administration_routes', manage_language_import('voie d\'administration', 'route of administration', $langcode), $langcode, false);
        },
        'dosage_forms' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'dosage_forms', manage_language_import('forme galénique', 'galeniq form', $langcode), $langcode, false);
        },
        'image' => function ($record, $langcode) {
            return ImportCsv::getAndUploadImageAndFile(trim($record[manage_language_import('photo de la molécule', 'picture of the molecule', $langcode)]), false);
        },
        'producer' => function ($record, $langcode) {
            return ImportCsv::getAndUploadImageAndFile(trim($record[manage_language_import('producteur', 'producer', $langcode)]), false);
        },
        'business_units' => function ($record, $langcode) {
            if (isset($record['bu'])) {
                return ImportCsv::getEntityReference($record, 'business_units', 'bu', $langcode, false);
            }
            return ImportCsv::setBusinessUnit(manage_language_import('Espace pharma', 'Pharmaceutical space', $langcode), $langcode);
        },
        'content' => function ($record, $langcode) {
            return ImportCsv::manageParagraphForData($record, [
                manage_language_import('documentation technique', 'technical documentation', $langcode)
                => $record[manage_language_import('documentation technique', 'technical documentation', $langcode)],
                manage_language_import('documentation réglementaire', 'regulatory document', $langcode) =>
                    $record[manage_language_import('documentation réglementaire', 'regulatory documentation', $langcode)],
            ]);
        },
    ],
    'chemi' => [
        'type' => function () {
            return 'node';
        },
        'bundle' => function () {
            return 'catalogs_chemi';
        },
        'color_index' => function ($record) {
            return Str::ucfirst(trim($record['color index']));
        },
        'tmff' => function ($record) {
            return Str::ucfirst(trim($record['tmff']));
        },
        'tg' => function ($record) {
            return Str::ucfirst(trim($record['tg']));
        },
        'ph' => function ($record) {
            return Str::ucfirst(trim($record['ph']));
        },
        'title' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('nom commercial', 'commercial name', $langcode)]));
        },
        'delivery_form' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('forme de livraison', 'aspect', $langcode)]));
        },
        'dry_active_matter' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('taux extrait sec', 'dry active matter', $langcode)]));
        },
        'number_cas' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('n° de cas', 'cas number', $langcode)]));
        },
        'description' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('descriptif', 'product description', $langcode)]));
        },
        'molecular_weight' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('poids moléculaire', 'molecular weight', $langcode)]));
        },
        'regulatory' => function ($record, $langcode) {
            return Str::ucfirst(trim($record[manage_language_import('réglementaire', 'regulatory aspects', $langcode)]));
        },
        'systems' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'systems', manage_language_import('système', 'system', $langcode), $langcode, false, ';');
        },
        'biosourced' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'biosourced', manage_language_import('biosourcé', 'biosourced rate', $langcode), $langcode, false);
        },
        'country_distribution' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'countries', manage_language_import('pays de distribution', 'distribution country', $langcode), $langcode, false, ';');
        },
        'country_origin' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'countries', manage_language_import('pays d\'origine', 'country of origin', $langcode), $langcode, false, ';');
        },
        'suppliers_chemistry' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'suppliers_chemistry', manage_language_import('fournisseur', 'supplier', $langcode), $langcode, true, ';');
        },
        'functions_chemistry' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'functions_chemistry', manage_language_import('fonction', 'function', $langcode), $langcode, false, ';');
        },
        'chemistry' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'chemistry', manage_language_import('chimie', 'chemistry', $langcode), $langcode, false, ';');
        },
        'applications' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'applications', manage_language_import('application', 'applications', $langcode), $langcode, false, ';');
        },
        'business_units' => function ($record, $langcode) {
            if (isset($record['bu'])) {
                return ImportCsv::getEntityReference($record, 'business_units', 'bu', $langcode, false);
            }
            return ImportCsv::setBusinessUnit(manage_language_import('Espace chimie', 'Cheumical space', $langcode), $langcode);
        },
        'image' => function ($record) {
            return ImportCsv::getAndUploadImageAndFile(trim($record['function']), true);
        },
    ],
    'food' => [
        'type' => function () {
            return 'node';
        },
        'bundle' => function () {
            return 'catalogs_food';
        },
        'title' => function ($record) {
            return Str::ucfirst(trim($record['products names']));
        },
        'fat_percentage' => function ($record) {
            return Str::ucfirst(trim($record['fat percentage']));
        },
        'fat_type' => function ($record) {
            return Str::ucfirst(trim($record['fat type']));
        },
        'mesh' => function ($record) {
            return Str::ucfirst(trim($record['mesh']));
        },
        'producers_food' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'producers_food', 'producer', $langcode, false);
        },
        'ingredients_specialties' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'ingredients_specialties', 'single ingredients/specialties', $langcode, false);
        },
        'product_type' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'product_type', 'type of product', $langcode, true);
        },
        'segments' => function ($record, $langcode) {
            return ImportCsv::getEntityReference($record, 'segments', 'segments', $langcode, false, ',');
        },
        'food_applications' => function ($record) {
            return Str::ucfirst(trim($record['applications']));
        },
        'recommended_app_func' => function ($record) {
            return Str::ucfirst(trim($record['recommended application/function']));
        },
        'distribution_country' => function ($record) {
            return Str::ucfirst(trim($record['distribution country']));
        },
        'generic_benefits' => function ($record) {
            return Str::ucfirst(trim($record['generic benefits']));
        },
        'business_units' => function ($record, $langcode) {
            if (isset($record['bu'])) {
                return ImportCsv::getEntityReference($record, 'business_units', 'bu', $langcode, false);
            }

            return ImportCsv::setBusinessUnit('Food space', $langcode);
        },
        'image' => function ($record) {
            return ImportCsv::getAndUploadImageAndFile(trim($record['nom du visuel']), false);
        },
    ],
    'extra' => [
        'en' => [
            'cos' => [
                'hair_skin' => function ($record, $langcode) {
                    return ImportCsv::getEntityReference($record, 'hair_skin', 'hair/skin', $langcode, false);
                },
                'main_claims' => function ($record, $langcode) {
                    return ImportCsv::getEntityReference($record, 'main_claims', 'main claims', $langcode, false);
                },
                'applications_cos' => function ($record, $langcode) {
                    return ImportCsv::getEntityReference($record, 'applications_cos', 'application', $langcode, false);
                },
                'solubility_dispersion' => function ($record) {
                    return Str::ucfirst(trim($record['solubility or dispersibility']));
                },
                'level_use' => function ($record) {
                    return Str::ucfirst(trim($record['% level of use']));
                },
                'origins' => function ($record) {
                    return Str::ucfirst(trim($record['origin']));
                },
            ]
        ],
        'fr' => [
            'cos' => [
                'appearances' => function ($record) {
                    return Str::ucfirst(trim($record['apparence']));
                },
                'benefits' => function ($record) {
                    return Str::ucfirst(trim($record['bénéfices']));
                },
                'granulometries' => function ($record) {
                    return Str::ucfirst(trim($record['granulométrie']));
                },
                'geographical_origins' => function ($record) {
                    return Str::ucfirst(trim($record['origine géographique']));
                },
                'product_informations' => function ($record) {
                    return Str::ucfirst($record['informations produits']);
                },
                'status_nano' => function ($record) {
                    return Str::ucfirst(trim($record['statut nano / non nano']));
                },
                'conservative_system' => function ($record) {
                    return Str::ucfirst(trim($record['système conservateur']));
                },
                'aggregate_size' => function ($record) {
                    return Str::ucfirst(trim($record['taille agrégats']));
                },
                'particles_size' => function ($record) {
                    return Str::ucfirst(trim($record['taille particule']));
                },
                'treatment' => function ($record) {
                    return Str::ucfirst(trim($record['traitement']));
                },
                'pigment_type' => function ($record) {
                    return Str::ucfirst(trim($record['type de pigment']));
                },
                'absorptions' => function ($record) {
                    return Str::ucfirst(trim($record['absorption']));
                },
            ]
        ]
    ]
];
