import { http } from '@inside-library/helpers/Http'

import { capsuleFields } from '../constants'

export const fetchFeaturedNews = async () => {
  try {
    const { data } = await http.get('content/news', {
      fields: capsuleFields,
      filters: {
        'status:eq': 1,
        'is_featured:eq': 1,
        limit: 5,
        'published_at:lte': 'now()',
        sort: 'published_at:desc'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}
