import registerURLs from '../mixins/register-urls'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    component: () => import('../pages/NewsPage'),
    meta: { disabled: false }
  },
  {
    name: 'DistributorsListingPage',
    path: registerURLs['distributors-listing'],
    component: () => import('../pages/DistributorsListingPage')
  },
  {
    name: 'GedPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    path: registerURLs['account-exists'],
    name: 'AccountExistsLogin',
    component: () => import('../components/register/PageRegisterCustoms'),
    props: {
      pageId: 'account-exists'
    },
    meta: {
      logout: true,
      requiresAuth: false
    }
  },
  {
    path: registerURLs['check-in'],
    name: 'CheckInLogin',
    component: () => import('../components/register/PageRegisterCustoms'),
    props: {
      pageId: 'check-in'
    },
    meta: {
      logout: true,
      requiresAuth: false
    }
  },
  {
    path: registerURLs['explain-registration'],
    name: 'ExplainRegistrationLogin',
    component: () => import('../components/register/PageRegisterCustoms'),
    props: {
      pageId: 'explain-registration'
    },
    meta: {
      logout: true,
      requiresAuth: false
    }
  },
  {
    path: registerURLs['start-registration'],
    name: 'StartRegistrationLogin',
    component: () => import('../components/register/PageRegisterCustoms'),
    props: {
      pageId: 'start-registration'
    },
    meta: {
      logout: true,
      requiresAuth: false
    }
  },
  {
    path: registerURLs['unauthorized-account'],
    name: 'UnauthorizedAccountLogin',
    component: () => import('../components/register/PageRegisterCustoms'),
    props: {
      pageId: 'unauthorized-account'
    },
    meta: {
      logout: true,
      requiresAuth: false
    }
  },
  {
    path: registerURLs['complete-profile'],
    name: 'CompleteYourProfile',
    component: () => import('../components/register/PageRegisterCustoms'),
    props: {
      pageId: 'complete-profile'
    },
    meta: {
      logout: true,
      requiresAuth: true
    }
  },
  {
    name: 'AdminRegistrationsPage',
    path: 'inscriptions',
    component: () =>
      import('../components/administration/AdminRegistrationsPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
