import SamlAuth from './components/auth/SamlAuth.vue'

export default {
  'inside-auth': {
    extraComponent: {
      is: SamlAuth
    }
  },
  'inside-commons': {
    banner: {
      imageKey: 'image'
    }
  },
  'inside-events': {
    fullLikesOnMobileDevices: true,
    rootRoute: {
      fr: 'agenda'
    }
  },
  'inside-ged': {
    rootRoute: {
      fr: 'mediatheque'
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    fullLikesOnMobileDevices: true,
    navigationEnabled: true
  },
  'inside-teams': {
    rootRoute: {
      fr: 'forum'
    }
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: false,
      useBackgroundImage: true
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    showFollow: false,
    shortcuts: {
      max: 2
    }
  }
}
