export default {
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { folders: ['title'] }
    ]
  },
  modal: {
    modalFields: ['class', 'content']
  },
  news: {
    modalFields: [
      'chapo',
      'content',
      'image',
      'title',
      'uuid',
      'published_at',
      'content_type',
      { domains: ['title', 'slug'] },
      { news_categories: ['title', 'slug', 'color'] },
      {
        reactions: [
          'count',
          { users: ['uuid', 'lastname', 'firstname', 'image'] }
        ]
      },
      { comments: ['count'] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'email',
      'status',
      'firstname',
      'address',
      'uuid',
      'hobby',
      'arrival_date',
      'lastname',
      'image',
      'function',
      'spoken_languages',
      'hobbies',
      'phone',
      'mobile_phone',
      {
        services: ['uuid', 'slug', 'title']
      },
      {
        locations: ['title', 'uuid']
      },
      {
        sites: ['title', 'uuid', 'slug']
      },
      {
        users: ['firstname', 'lastname', 'uuid', 'function', 'image']
      }
    ]
  },
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'created_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  }
}
