<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\TRYB\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('popin', ['uses' => 'PopinController@popin']);
        $router->post('reaction/popin', ['uses' => 'ReactionController@reaction']);

        /**
         * Special TRYB registration
         *
         * From leo:
         * - /demande-de-creation-de-compte => Là on le champs e-mail et les 3 cas possibles (redirection vers
         * “mot de passe oublié“, “envoie d’un mail”, “message d’infos”)
         * - /creer-mon-mot-de-passe => 2 champs pour créer son mdp
         * - /creer-mon-compte => Là on a le formulaire en 2 étapes avec tous les champs
         */
        $router->post(
            'registration/checkin',
            [
                'as'   => 'registration.checkin',
                'uses' => 'RegistrationController@checkinRegistration',
            ]
        );
        $router->post(
            'registration/register',
            [
                'as'   => 'registration.create',
                'uses' => 'RegistrationController@createRegistration',
            ]
        );

        $router->get(
            'registration/validate',
            [
                'as'   => 'registration.validate',
                'uses' => 'RegistrationController@validateRegistration',
            ]
        );

        $router->post(
            'registration/complete/{uuid}',
            [
                'as'   => 'registration.complete',
                'uses' => 'RegistrationController@completeRegistration',
            ]
        );

        $router->put(
            'registration/update/{uuid}',
            [
                'as'   => 'registration.update',
                'uses' => 'RegistrationController@updateUserStatus',
            ]
        );
    }
);

Route::group(
    [
        'namespace'  => 'Inside\TRYB\Http\Controllers',
    ],
    function ($router) {
        $router->get('rss.xml', ['uses' => 'FeedController@rss']);
    }
);
