<?php

namespace Inside\TRYB\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;

class PrepareRegistration extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * @var string special signed link
     */
    protected $link;

    /**
     * @var string $locale
     */
    public $locale;

    /**
     * Create a new message instance.
     *
     * @param string $locale la langue de l'utilisateur
     * @param string $link   le lien de retour
     * @return void
     */
    public function __construct(string $locale, string $link)
    {
        $this->link   = $link;
        $this->locale = $locale;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.registration')->subject(
            Lang::get('registration.mail.prepare.subject', [], $this->locale)
        )->with(
            [
                'lines'      => explode(
                    "\n",
                    Lang::get('registration.mail.prepare.content', [], $this->locale)
                ),
                'actionUrl'  => $this->link,
                'actionText' => Lang::get('registration.mail.prepare.button', [], $this->locale),
            ]
        );
    }
}
