<?php

namespace Inside\TRYB\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\News;
use Laravel\Lumen\Routing\Controller;

class PopinController extends Controller
{
    // return if popin has to be shown or not (if the last one was not shown today or if reactionable_uuid is not the
    // same as last flash info uuid
    public function popin(Request $request): array
    {
        $flashInfo = News::query()->where('is_flash', 1)->where('status', 1)->orderBy('created_at', 'DESC')->first();

        if (empty($flashInfo)) {
            return [
                'popin' => false,
            ];
        }

        /** @var User $user */
        $user = Auth::user();

        $reaction = DB::table('inside_reactions')
            ->where('type', 'flashinfo')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $flashInfo->uuid)
            ->where('created_at', 'LIKE', date('Y-m-d', time()) . ' %')
            ->orderBy('created_at', 'DESC')->get();

        $count = $reaction->count();

        return [
            'popin' => !(bool)$count,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first()
        ];
    }
}
