<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class ChangeExistingUsersStatus extends Migration
{
    public function up(): void
    {
        $users = Users::query()->where('is_from_ldap', 0)->where('registration_status', false)->get();

        $bridge = new BridgeContent();

        foreach ($users as $user) {
            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'registration_status' => 'accepted'
            ]);
        }
    }

    public function down(): void
    {
    }
}
