<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddUserRegistrationStatusField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            [
                'type'                => BridgeContentType::LIST_STRING_FIELD,
                'name'                => 'registration_status',
                'searchable'          => false,
                'translatable'        => true,
                'search_result_field' => true,
                'required'            => true,
                'weight'              => 0,
                'title'               => [
                    'fr' => 'Statut d\'inscription',
                ],
                'settings' => [
                    'allowed_values' => [
                        'pending' => [
                            'fr' => 'En attente',
                        ],
                        'accepted' => [
                            'fr' => 'Accepté',
                        ],
                        'declined' => [
                            'fr' => 'Refusé',
                        ],
                    ],
                ],
                'widget'              => [
                    'hidden' => true,
                ],
            ],
            [
                'name' => 'registration_message',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Introduction',
                ],
                'widget' => [
                    'hidden' => true
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        ];

        foreach ($fields as $field) {
            $bridge->contentTypeCreateOrUpdateField('users', $field['name'], $field);
        }
    }

    public function down(): void
    {
    }
}
