<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Symfony\Component\Console\Formatter\OutputFormatterStyle;
use Symfony\Component\Console\Output\ConsoleOutput;

class AddNewsCategoriesColor extends Migration
{
    /** @var ConsoleOutput|null */
    protected $console = null;

    /** @var BridgeContentType */
    private $bridgeContentType;

    public function __construct()
    {
        $this->bridgeContentType = new BridgeContentType();
        $this->console = $this->getConsole();
    }

    private function getConsole(): ConsoleOutput
    {
        if (!$this->console) {
            // Prepare a console
            $this->console = new ConsoleOutput();
            $outputStyle = new OutputFormatterStyle('red', 'default');
            $this->console->getFormatter()->setStyle('error', $outputStyle);
            $outputStyle = new OutputFormatterStyle('yellow', 'default', ['bold', 'underscore']);
            $this->console->getFormatter()->setStyle('class', $outputStyle);
        }

        return $this->console;
    }

    public function up(): void
    {
        if ($this->bridgeContentType->contentTypeCreateOrUpdateField(
            'news_categories',
            'color',
            [
                'name' => 'color',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Couleur',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 8,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        )) {
            if ($this->console) {
                $this->console->writeln('<info>Le champs <comment>color</comment> du contenu <class>news_categories</class> a bien été mis à jour.</info>');
            }
        } else {
            if ($this->console) {
                $this->console->writeln('<error>Le champs <comment>color</comment> du contenu <class>news_categories</class> n\'a pas été mis à jour.</error>');
            }
        }
    }

    public function down(): void
    {
    }
}
