<?php

use Illuminate\Database\Migrations\Migration;

class ContentsMigration106 extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__, 'tryb-back');

        $fieldsToRemove = ['function', 'mobile', 'sector', 'phone'];

        foreach ($fieldsToRemove as $field) {
            $this->bridge->contentTypeDeleteField('user', 'user', $field);
        }

        $this->migrateContent('users', false);

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
