<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'events',
        'title' => [
            'fr' => 'Événements'
        ],
    ],
    'fields' => [
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => ['text', 'text_with_image', 'image', 'file', 'video', 'map', 'html', 'accordion', 'call_to_action', 'files', 'slider'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'date',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Date',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'disable_comments',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Désactiver les commentaires',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 8,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'events_categories',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 13,
            'title' => [
                'fr' => 'Categories d\'événements',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
                'weight' => 13,
                'group' => 'group_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['events_categories'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'is_featured',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Est mis en avant ?',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 7,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'place',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Lieu',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'comments',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Commentaires',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::COMMENT_FIELD,
            'settings' => [
                'comment_type' => 'comments',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'end_date',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Date de fin',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
