<?php

return [
    'schedule' => [
        'ldap' => function ($scheduler) {
            $scheduler->command('inside:user:import ldap --entry="default" --disable-not-imported')->daily()->at('0:00')->description('ldap default');
        },
        'ldap_tryba' => function ($scheduler) {
            $scheduler->command('inside:user:import ldap --entry="tryba" --filter="(&(objectCategory=person)(objectClass=user)(|(company=*telepro*)(company=*tryba industrie*)(company=*tryba mayenne*)(company=*atrya création*)(company=*atwin*)(company=*vérandier*)(company=*thareaut*)(company=*gewal*))(!(userprincipalname=salle*)))" --disable-not-imported')->daily()->at('2:00')->description('ldap tryba');
        },
        'birthdays' => function ($scheduler) {
            $scheduler->command('tryb:birthday-mails')->daily()->at('6:00');
        },
    ],
];
