<?php

use Adldap\Models\Entry;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Company;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\Services;
use Inside\Content\Models\Contents\Users;
use Symfony\Component\Finder\Finder;

return [
    'user_filter' => 'is_from_ldap',
    'sync_attributes' => [
        // Inside => LDAP
        'name'                => 'userprincipalname',
        'mail'                => 'mail',
        'firstname'           => 'givenname',
        'lastname'            => 'sn',
        'company'             => 'company',
        'functions'           => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
            if (!$user->hasAttribute('title')) {
                return [];
            }

            $functions = [];

            $userFunctions = $user->getAttribute('title');

            foreach ($userFunctions as $functionName) {
                if (empty($functionName)) {
                    continue;
                }

                $uuid    = false;
                $function = Functions::where('title', $functionName)->first();

                if ($function) {
                    $uuid = $function->uuid;
                } else {
                    $uuidBridge = $bridge->contentInsert(
                        'functions',
                        [
                            'type'   => 'node',
                            'bundle' => 'functions',
                            'title'  => $functionName,
                            'uid'    => 1,
                        ]
                    );

                    $function = Functions::find($uuidBridge);

                    if ($function) {
                        $uuid = $function->uuid;
                    }
                }

                if ($uuid) {
                    $functions[] = $uuid;
                }
            }

            if (!empty($functions)) {
                return $functions;
            }

            return [];
        },
        'is_maintenance' => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
            return false;
        },
        'is_from_ldap' => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
            return true;
        }
    ],
];
