<?php

$customConnectionOptions = [];
if (env('ADLDAP_DONT_CHECK_TLS_CERTIFICAT', false)) {
    $customConnectionOptions[LDAP_OPT_X_TLS_REQUIRE_CERT] = LDAP_OPT_X_TLS_NEVER;
}

return [
    'connections' => [
        'default' => [
            'auto_connect'        => env('ADLDAP_AUTO_CONNECT', true),
            'connection'          => Adldap\Connections\Ldap::class,
            'schema'              => Adldap\Schemas\OpenLDAP::class,
            'connection_settings' => [
                'account_prefix'       => env('ADLDAP_ACCOUNT_PREFIX', ''),
                'account_suffix'       => env('ADLDAP_ACCOUNT_SUFFIX', ''),
                'domain_controllers'   => explode(' ', env('ADLDAP_CONTROLLERS', 'staging.maecia.com')),
                'port'                 => env('ADLDAP_PORT', 389),
                'timeout'              => env('ADLDAP_TIMEOUT', 5),
                'base_dn'              => env('ADLDAP_BASEDN', 'ou=External,dc=staging2,dc=maecia,dc=com'),
                'admin_account_prefix' => env('ADLDAP_ADMIN_ACCOUNT_PREFIX', ''),
                'admin_account_suffix' => env('ADLDAP_ADMIN_ACCOUNT_SUFFIX', ''),
                'admin_username'       => env(
                    'ADLDAP_ADMIN_USERNAME',
                    'cn=ndeniaud,ou=External,dc=staging2,dc=maecia,dc=com'
                ),
                'admin_password'       => env('ADLDAP_ADMIN_PASSWORD', 'maecia'),
                'follow_referrals'     => false,
                'use_ssl'              => env('ADLDAP_USE_SSL', false),
                'use_tls'              => env('ADLDAP_USE_TLS', true),
                'custom_options'       => $customConnectionOptions,
            ],
        ],
        'tryba' => [
            'auto_connect'        => env('ADLDAP_TRYBA_AUTO_CONNECT', true),
            'connection'          => Adldap\Connections\Ldap::class,
            'schema'              => Adldap\Schemas\OpenLDAP::class,
            'connection_settings' => [
                'account_prefix'       => env('ADLDAP_TRYBA_ACCOUNT_PREFIX', ''),
                'account_suffix'       => env('ADLDAP_TRYBA_ACCOUNT_SUFFIX', ''),
                'domain_controllers'   => explode(' ', env('ADLDAP_TRYBA_CONTROLLERS', 'staging.maecia.com')),
                'port'                 => env('ADLDAP_TRYBA_PORT', 389),
                'timeout'              => env('ADLDAP_TRYBA_TIMEOUT', 5),
                'base_dn'              => env('ADLDAP_TRYBA_BASEDN', 'ou=External,dc=staging2,dc=maecia,dc=com'),
                'admin_account_prefix' => env('ADLDAP_TRYBA_ADMIN_ACCOUNT_PREFIX', ''),
                'admin_account_suffix' => env('ADLDAP_TRYBA_ADMIN_ACCOUNT_SUFFIX', ''),
                'admin_username'       => env(
                    'ADLDAP_TRYBA_ADMIN_USERNAME',
                    'cn=ndeniaud,ou=External,dc=staging2,dc=maecia,dc=com'
                ),
                'admin_password'       => env('ADLDAP_TRYBA_ADMIN_PASSWORD', 'maecia'),
                'follow_referrals'     => false,
                'use_ssl'              => env('ADLDAP_TRYBA_USE_SSL', false),
                'use_tls'              => env('ADLDAP_TRYBA_USE_TLS', true),
                'custom_options'       => $customConnectionOptions,
            ],
        ],
    ],
];
