<?php

namespace Inside\TRYB\Providers;

use Illuminate\Container\Container;
use Inside\TRYB\Console\SendBirthdayMails;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\TRYB\Services\Registration;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * TRYB Service provider.
 *
 * @category Class
 * @package  Inside\TRYB\Providers\ServiceProvider
 * @author   Maecia <contact@feldoe.net>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    public array $bindings = [
        'registration' => Registration::class,
    ];

    protected array $commands = [
        SendBirthdayMails::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeConfigFrom(__DIR__.'/../../config/authorized.php', 'authorized');
            $this->mergeConfigFrom(__DIR__.'/../../config/layout_pathes.php', 'layout_pathes');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/app.php', 'app');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap.php', 'ldap');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
