<?php

namespace Inside\TRYB\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\Users;

class PendingAccount extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * @var string user uuid
     */
    protected $uuid;

    /** @var array */
    protected $data;

    /**
     * Create a new message instance.
     *
     * @param string $uuid
     * @param array $data
     */
    public function __construct(string $uuid, array $data)
    {
        $this->uuid = $uuid;

        $fields = [
            'firstname' => 'Prénom',
            'lastname' => 'Nom',
            'birthday' => 'Date de naissance',
            'functions' => 'Fonction',
            'company' => 'Société'
        ];

        $user = Users::query()->find($uuid);

        $this->data[] = 'Email : ' . $user->email;

        foreach ($data as $key => $value) {
            if (!array_key_exists($key, $fields)) {
                continue;
            }

            switch ($key) {
                case 'birthday':
                    $date = strtotime($value);
                    $value = date('d/m/Y', $date);
                    break;
                case 'functions':
                    $function = Functions::query()->find($value);
                    $value = $function->title;
                    break;
                default:
                    break;
            }

            $this->data[] = $fields[$key] . ' : ' . $value;
        }
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $data = implode("\n", $this->data);

        return $this->markdown('emails.registration')->subject(
            Lang::get('registration.mail.pending.subject')
        )->with(
            [
                'lines'      => explode(
                    "\n",
                    Lang::get('registration.mail.pending.content', ['data' => $data])
                ),
                'actionUrl'  => env('APP_URL') . '/settings/registrations?user=' . $this->uuid,
                'actionText' => Lang::get('registration.mail.pending.button'),
            ]
        );
    }
}
