<?php

namespace Inside\TRYB\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Models\Contents\Users;

class HappyBirthday extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * @var Users $user the user
     */
    protected $user;

    /**
     * Create a new message instance.
     *
     * @param Users $user the user
     * @return void
     */
    public function __construct(Users $user)
    {
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.birthday')->subject(
            Lang::get('mail.birthday.subject', [])
        )->with(
            [
                'lines'      => explode(
                    "\n",
                    str_replace('%firstname%', trim($this->user->firstname), Lang::get('mail.birthday.content', []))
                ),
            ]
        );
    }
}
