<?php

namespace Inside\TRYB\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;

class AccountStatusChanged extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * @var string user uuid
     */
    protected $uuid;

    /**
     * @var string status
     */
    protected $status;

    /**
     * @var string message
     */
    protected $message;

    /**
     * Create a new message instance.
     *
     * @param string $uuid
     * @param string $status
     * @param string $message
     */
    public function __construct(string $uuid, string $status, string $message)
    {
        $this->uuid = $uuid;
        $this->status = $status;
        $this->message = $message;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        //        $lines = ($this->status === 'declined' && !empty(trim($this->message))) ? Lang::get('registration.mail.' . $this->status . '.content.with_message', [':message' => trim($this->message)]) : Lang::get('registration.mail.' . $this->status . '.content');

        $lines = Lang::get('registration.mail.' . $this->status . '.content');

        return $this->markdown('emails.registration')->subject(
            Lang::get('registration.mail.' . $this->status . '.subject')
        )->with(
            [
                'lines'      => explode(
                    "\n",
                    $lines
                ),
                'actionUrl'  => $this->status === 'accepted' ? env('APP_URL') : ('mailto:' . env('TRYB_REGISTRATION_ADMIN_MAIL', 'dpfister@tryba.fr')),
                'actionText' => Lang::get('registration.mail.' . $this->status . '.button'),
            ]
        );
    }
}
