<?php

namespace Inside\TRYB\Http\Controllers;

use Illuminate\Support\Facades\Storage;
use Inside\Content\Models\Contents\News;
use Inside\User\Http\Controllers\Controller;

class FeedController extends Controller
{
    /**
     * @return \Illuminate\Http\Response|\Laravel\Lumen\Http\ResponseFactory
     */
    public function rss()
    {
        $allNews = News::withoutGlobalScopes()
            ->where('status', '=', 1)
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get();

        $baseUrl = config('app.url');

        $rssAttributes = [
            'xmlns:dc' => 'http://purl.org/dc/elements/1.1/',
            'xmlns:atom' => 'http://www.w3.org/2005/Atom',
            'xmlns:content' => 'http://purl.org/rss/1.0/modules/content/',
            'xmlns:foaf' => 'http://xmlns.com/foaf/0.1/',
            'xmlns:og' => 'http://ogp.me/ns#',
            'xmlns:rdfs' => 'http://www.w3.org/2000/01/rdf-schema#',
            'xmlns:sioc' => 'http://rdfs.org/sioc/ns#',
            'xmlns:sioct' => 'http://rdfs.org/sioc/types#',
            'xmlns:skos' => 'http://www.w3.org/2004/02/skos/core#',
            'xmlns:xsd' => 'http://www.w3.org/2001/XMLSchema#',
            'xmlns:base' => "{$baseUrl}/rss.xml",
            'xmlns:version' => '2.0',
        ];

        $xml = new \XMLWriter();
        $xml->openMemory();
        $xml->startDocument('1.0', 'utf-8');
        $xml->startElement('rss');

        foreach ($rssAttributes as $name => $value) {
            $xml->writeAttribute($name, $value);
        }

        $xml->startElement('channel');
        $xml->writeElement('title');
        $xml->writeElement('link', "{$baseUrl}/rss.xml");
        $xml->writeElement('description');
        $xml->writeElement('language', 'fr');
        $xml->startElement('atom:link');
        $xml->writeAttribute('href', "{$baseUrl}/rss.xml");
        $xml->writeAttribute('ref', 'self');
        $xml->writeAttribute('type', 'application/rss+xml');
        $xml->endElement();

        foreach ($allNews as $news) {
            $xml->startElement('item');
            $xml->writeElement('title', $news->title);
            $xml->writeElement('link', $baseUrl.'/'.implode('/', $news->slug));
            $xml->startElement('description');

            if (!empty($news->image) && Storage::disk('local')->exists($news->image)) {
                if (!Storage::disk('public')->exists($news->image)) {
                    Storage::disk('public')->put($news->image, Storage::get($news->image));
                }
                $imageUrl = Storage::disk('public')->url($news->image);
                [$height, $width] = (array) getimagesize(Storage::disk('public')->path($news->image));
                $imgTag = "<img typeof=\"foaf:Image\" src=\"{$imageUrl}\" height=\"$height\" width=\"$width\" alt=\"\"/>";
                $xml->text($imgTag);
            }

            $xml->endElement();
            $xml->writeElement('pubDate', date('d/m/Y - H:i', $news->created_at));
            $xml->writeElement('dc:author', $news->authors()->get()->implode('name', ', '));
            $xml->writeElement('guid', $news->uuid);
            $xml->endElement();
        }

        $xml->endElement();
        $xml->endElement();
        $xml->endDocument();

        return response($xml->outputMemory(), 200)->header('Content-Type', 'application/xml');
    }
}
