<?php

namespace Inside\TRYB\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use Inside\Content\Models\Contents\Users;
use Inside\TRYB\Mail\HappyBirthday;

class SendBirthdayMails extends Command
{
    /**
     * @var string
     */
    protected $name = 'tryb:birthday-mails';

    /*
   * @var string
   */
    protected $signature = 'tryb:birthday-mails';

    /**
     * @var string
     */
    protected $description = 'Send birthday mails';

    /**
     * Import users
     */
    public function handle(): void
    {
        $users = Users::query()->where('birthday', 'like', '%' . date('-m-d') . '%')->get();

        foreach ($users as $user) {
            Mail::to($user->email)->send(new HappyBirthday($user));
        }
    }
}
