<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;

class FixUserBirthdays extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $bridge = new BridgeContent();
        $users = Users::query()->where('birthday', 'like', '2020-08-04%')->get();

        $i = 1;
        foreach ($users as $user) {
            $this->writeln(sprintf('[%d/%d] Resetting birthday for user %s [%s]', $i++, count($users), $user->name, $user->email));
            $bridge->contentUpdate('users', [
                'uuid_host' => $user->uuid_host,
                'birthday' => null,
            ]);
        }
    }

    public function down(): void
    {
    }
}
