<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class FixGroupLikeEmailLink extends Migration
{
    public function up(): void
    {
        /** @var NotificationType $notificationType */
        $notificationType = NotificationType::query()->where('via', 'email')->where('event', 'Inside\Reaction\Events\ReactionSubscribedEvent')->where('action', 'like')->where('type', 'group')->first();

        $notificationType->data = [
            'title' => 'notifications.group.like.groups_posts.title',
            'description' => 'notifications.group.like.groups_posts.description',
            'icon' => 'group',
            'text' => 'notifications.group.like.groups_posts.text',
            'mail' => [
                'subject' => 'notifications.reaction.like.mail.subject',
                'text' => 'notifications.group.like.groups_posts.text',
                'buttonText' => 'notifications.group_posts.mail.buttonText',
            ],
            'fields' => [
                'title',
                'groups' => ['title'],
                'authors' => ['firstname', 'lastname'],
            ],
            'url' => 'ROOT_RELATION:groups',
        ];

        $notificationType->save();
    }

    public function down(): void
    {
    }
}
